"use strict";
/**
 * This module is a thin wrapper over the shared libraries used to manage the content filtering service and communicate with it.
 *
 * @module @wontok/node-addon-content-filtering
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initLib = void 0;
//#region imports
var node_addon_shared_lib_loader_1 = require("../node-addon-shared-lib-loader");
var native_api_1 = require("./native-api");
var path_1 = __importDefault(require("path"));
var commands_1 = require("./commands");
var utils_1 = require("../utils");
var initLib = function (publicOptions) {
    var libRelativePath = __dirname + "/../../demo-lib/.build/x86_64-apple-macosx/debug/libdemo-lib.dylib";
    var libAbsolutePath = path_1.default.resolve(libRelativePath);
    var sharedLib = {
        path: libAbsolutePath,
        initSymbol: "demoLibInitialize",
        executeCommandsSymbol: "demoLibExecuteCommands",
    };
    var initOptions = {
        demoOption: "demoValue",
    };
    var onSomeEventCallback = function (event) {
        utils_1.debug("Got someEvent in private JS Land (lib): " + JSON.stringify(event) + "\n");
        publicOptions.onSomeEvent(event);
    };
    onSomeEventCallback.callbackName = native_api_1.CallbackNames.someEvent;
    var _a = node_addon_shared_lib_loader_1.initSharedLib(sharedLib, initOptions, [
        onSomeEventCallback,
    ]), executeCommands = _a.executeCommands, unload = _a.unload;
    return {
        commandSomeCommand: function () { return executeCommands([commands_1.commandSomeCommand()]); },
        unload: unload,
    };
};
exports.initLib = initLib;
